//===============================================================================================
// Provides helper methods to display the privacy preferences site
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gPrivacyPrefURL = "https://privacy.intuit.com/cpi/do/preferences";
gProReviewPrivacyPrefURL = "http://intuit-tt-gn001.taxaudit.com";

gPrivacyPrefsFrm = null;

gPrivacyIds = new Array(   "p_firstname", 
                           "p_lastname",
                           "p_address",
                           "p_address2",
                           "p_city",
                           "p_state",
                           "p_zip",
                           "p_zip4",
                           "p_dayphone",
                           "p_dayext",
                           "email" );                          

//----------------------------------------------------------------------------
function showPrivacyPrefs( bRetail, srcIds )
   // Use the specified set of Ids that are used to retreive data from the page
   // to prepop the items specified by gPrivacyMap
{
   if( !srcIds ) return;

   var w = screen.availWidth;
   if( w > 800 ) w = 800;
   
   var h = screen.availHeight;
   if( h > 600 ) h = 600;
   
   var opt = "resizable=yes,scrollbars=yes,status=no,toolbar=no,menubar=no,location=no,directories=no";
   opt += ",width="+w;
   opt += ",height="+h;
   
   dlg=window.open( "../dlg/blank.htm", "privacyPrefs",  opt );

   // Create a hidden form to post
   var dlgDoc = dlg.document;
   var f = _createPrivacyForm( bRetail, dlgDoc );

   var dest, destLen = gPrivacyIds.length;
   var src, srcLen = srcIds.length;
   
   for( var i=0; i<destLen && i<srcLen; ++i )
   {
      dest = dlgDoc.getElementById( gPrivacyIds[i] );
      if( dest )
      {
         src = null;       
         if( srcIds[i] && srcIds[i].length>0 ) src = document.getElementById( srcIds[i] );
         if( src )
         {
            // Do processing of values          
            dest.value = src.value;
            if( dest.value.length > 0 )
            {
               if( "p_dayphone" == dest.id )
               {
                  // strip non digits
                  var re = /\D/g;
                  dest.value = dest.value.replace( re, '' );
               }
               else if( "p_zip" == dest.id )
               {
                  // strip non digits
                  var re = /\D/g;
                  dest.value = dest.value.replace( re, '' );
                  
                  if( dest.value.length>5)
                  {
                     var zip = dest.value;
                     dest.value = zip.substr(0,5);

                     var z4 = dlgDoc.getElementById( "p_zip4" );
                     if( z4 )
                     {
                        z4.value = zip.substr( 5, 4 );
                     }  
                  }
               }           
            }  
         }  
      }
   }
   
   gPrivacyPrefsFrm = f;
   setTimeout( "gPrivacyPrefsFrm.submit()", 100 );
      // relinquish control to browser first
}

//----------------------------------------------------------------------------
function showProReviewPrivacyPrefs()
{     
   var w = screen.availWidth;
   if( w > 700 ) w = 700;
   
   var h = screen.availHeight - 50;
   
   var opt = "dialogWidth:" + w + "px; dialogHeight:" + h + "px; help:No; resizable:Yes; status:No;";
   showModelessDialog( gProReviewPrivacyPrefURL, null, opt );
}

//----------------------------------------------------------------------------
// Impl Helpers
//----------------------------------------------------------------------------
function _createPrivacyForm( bRetail, d )
   // Create a hidden form
{
   var f=d.createElement("FORM");
   if(!f)return;
         
   f.style.position = "absolute";
   f.style.left = "-500px";
   f.style.top = "-500px";
   f.style.width = "500px";
   f.style.visibility = "hidden";
   f.target = "_self";
   f.method = "post";   
   f.action = gPrivacyPrefURL + "?dialog=1&p_closeoncancel=1&hidenav=1&p_sourceid=" + (bRetail?"32":"31");
   
   var e = d.createElement("INPUT");
   e.name = "dialog";
   e.value = "1";
   f.appendChild(e);
   
   e = d.createElement("INPUT");
   e.name = "p_closeoncancel";
   e.value = "1";
   f.appendChild(e); 
   
   e = d.createElement("INPUT");
   e.name = "hidenav";
   e.value = "1";
   f.appendChild(e);

   e = d.createElement("INPUT");
   e.name = "p_sourceid";
   e.value = (bRetail) ? "32" : "31";
   f.appendChild(e);
   
// e = d.createElement("INPUT");
// e.name = "p_prioritycode";
// e.value = (bRetail) ? "akx10015s0011ka2" : "akx10015s0012ka2 ";
// f.appendChild(e);

   var cnt = gPrivacyIds.length;
   for( var i=0; i<cnt; ++i )
   {
      e = d.createElement("INPUT");
      if( e )
      {
         e.id = gPrivacyIds[i];
         e.name = gPrivacyIds[i];
         f.appendChild( e );        
      }
   }
   
   d.body.appendChild( f );

   return f;
}
